﻿using IronBarCode;
using IronSoftware.Drawing;
using System;
using System.Drawing;
using System.Windows.Forms;

namespace MsiInstallerSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            IronSoftware.Logger.LoggingMode = IronSoftware.Logger.LoggingModes.All;
            IronSoftware.Logger.LogFilePath = "Default.log";

            IronBarCode.License.LicenseKey = "IRONBARCODE-MYLICENSE-KEY-1EF01";

            using (OpenFileDialog openFileDialog = new OpenFileDialog())
            {
                openFileDialog.Filter = "Image files (All files (*.*)|*.*";

                if (openFileDialog.ShowDialog() == DialogResult.OK)
                {
                    try
                    {
                        // Load the selected image
                        using (Bitmap bmp = new Bitmap(openFileDialog.FileName))
                        {
                            // Process the image
                            AnyBitmap anyBitmap = AnyBitmap.FromBitmap(bmp);

                            // Configure barcode reader options (customize as needed)
                            var option = new BarcodeReaderOptions
                            {
                                Speed = ReadingSpeed.Detailed,
                                ExpectMultipleBarcodes = true,
                                ScanMode = BarcodeScanMode.Auto,
                            };

                            BarcodeResults result = IronBarCode.BarcodeReader.Read(anyBitmap, option);

                            if (result.Count > 0)
                            {
                                string output = string.Empty;
                                foreach(var barcode in result)
                                {
                                    Console.WriteLine($"Barcode Found: {barcode.Text}");
                                    output += barcode.Text + "\n";
                                }

                                MessageBox.Show($"Detected Barcodes: \n{output}");
                            }
                            else
                            {
                                MessageBox.Show("No Barcode found.");
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show($"{ex.Message}");
                    }
                }
            }
        }
    }
}
